\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{assign}[2024/06/25 v0.89]
%
% (c) 2022-2024 Benjamin Bernard under the Latex Project Public License
% Research assistance from 	王芝雲 (Zoe Wang) is greatly appreciated
%
\LoadClassWithOptions{article}
\RequirePackage[T1]{fontenc}
% setspace has to be loaded before hyperref and microtype
\RequirePackage[nodisplayskipstretch]{setspace}
\RequirePackage[protrusion=false]{microtype}
% microtype will mess up the spacing of the \@@item
\RequirePackage{amsmath, lmodern, enumitem, xcolor, pgfmath, pgffor, xspace, environ, caption}
\RequirePackage{caption}
\captionsetup{font=small, labelfont=bf}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%		Class options
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\makeatletter
\newif\ifsolution@bas
\newif\ifassign@bas
\newif\ifta@bas
\newif\ifexport@pt@bas
\newif\ifshowpts@bas
\newif\iffrenchindent@bas
\newif\ifparts@bas
\newif\ifqbank@bas
\newif\ifoverleaf@bas
\newif\ifsln@showquestion@bas
\solution@bastrue
\assign@bastrue
\ta@bastrue
\showpts@basfalse
\let\titlesize@bas\large
\def\titlesize#1{\let\titlesize@bas#1}
\def\linespread@bas{1.09}
\def\pt@level@bas{2}
%
\DeclareOption{12pt}{\def\linespread@bas{1.1}\let\titlesize@bas\normalsize}
\DeclareOption{11pt}{\def\linespread@bas{1.15}}
\DeclareOption{10pt}{\def\linespread@bas{1.2}}
\DeclareOption{French}{\frenchindent@bastrue}
\DeclareOption{parts}{\parts@bastrue}
\DeclareOption{points}{\def\basmode{assign}\showpts@bastrue}
%\DeclareOption{draft}{\def\basmode{draft}\def\pt@level@bas{2}}
\DeclareOption{draft}{\def\basmode{draft}}
\DeclareOption{solution}{\def\basmode{solution}}
\DeclareOption{assign}{\def\basmode{assign}}
\DeclareOption{exam}{\showpts@bastrue}
\DeclareOption{ta}{\def\basmode{grading}}
\DeclareOption{grading}{\def\basmode{grading}}
\DeclareOption{qbank}{\qbank@bastrue}
\DeclareOption{overleaf}{\overleaf@bastrue}
\DeclareOption{proof}{%
	\def\sol@bas{\vspace{\numexpr 2*\enit@depth-6\relax mm}\begin{proof}[Solution]}%
	\def\endsol@bas{\end{proof}\vspace{\numexpr2*\enit@depth-6\relax mm}}%
}
\ProcessOptions\relax
%
\ifqbank@bas
	\RequirePackage[small]{titlesec}
	\let\titlesize@bas\Large
\fi
\ifoverleaf@bas
    \RequirePackage[realmainfile]{currfile}
    \def\jobname@bas{\currfilebase}
\else
    \def\jobname@bas{\jobname}
\fi
% Customization: points
\newif\ifpt@hierarchy@bas
\newif\ifpt@margin@bas
\def\pt@label@bas{point}
\def\pt@sep@bas{ }
\let\pt@font@bas\normalsize
\define@key{pt@bas}{bonus color}{\colorlet{bonus}{#1}}
\define@key{pt@bas}{totals color}{\colorlet{ptdisplay}{#1}}
\define@key{pt@bas}{pt color}{\colorlet{points}{#1}}
\define@key{pt@bas}{font}{\let\pt@font@bas#1}
\define@key{pt@bas}{label}{\def\pt@label@bas{#1}}
\define@key{pt@bas}{sep}{\def\pt@sep@bas{#1}}
\define@key{pt@bas}{margin}[true]{%
	\ifstreq@bas{#1}{true}{\pt@margin@bastrue}{\pt@margin@basfalse}%
}
\define@key{pt@bas}{hierarchy}{%
	\ifstreq@bas{#1}{lowest}{\pt@hierarchy@bastrue}{\def\pt@level@bas{#1}}%
}
\def\pointsetup#1{\setkeys{pt@bas}{#1}}
% Customization: questions
\newif\ifcoupledcolors%
\coupledcolorstrue%
\define@key{q@bas}{color}{\colorlet{question}{#1}\ifcoupledcolors\colorlet{hint}{#1}\colorlet{slnquestion}{#1}\fi}
\define@key{q@bas}{font}{\def\qfont{#1}}
\define@key{q@bas}{hint color}{\colorlet{hint}{#1}}
\define@key{q@bas}{hint font}{\def\hfont{#1}}
\def\questionsetup#1{\setkeys{q@bas}{#1}}
% Customization: solutions
\newif\ifsln@points@bas
\def\sln@header@bas{}
\def\sln@title@bas{Solutions}
\define@key{sln@bas}{color}{\colorlet{answer}{#1}}
\define@key{sln@bas}{show question}[true]{%
	\ifstreq@bas{#1}{true}{%
		\sln@showquestion@bastrue\iffrenchindent@bas\answer@indent@bastrue\fi%
	}{%
		\sln@showquestion@basfalse\answer@indent@basfalse%
}}
\define@key{sln@bas}{indent answer}[true]{%
	\ifstreq@bas{#1}{true}{\answer@indent@bastrue}{\answer@indent@basfalse}%
}
\define@key{sln@bas}{show points}[true]{%
	\ifstreq@bas{#1}{true}{\sln@points@bastrue}{\sln@points@basfalse}%
}
\define@key{sln@bas}{font}{\def\afont{#1}}
\define@key{sln@bas}{question color}{\colorlet{slnquestion}{#1}}
\define@key{sln@bas}{question font}{\def\slnqfont{#1}}
\define@key{sln@bas}{header}{\def\sln@header@bas{#1}}
\define@key{sln@bas}{title}{\def\sln@title@bas{#1}}
\def\solutionsetup#1{\setkeys{sln@bas}{#1}}
% Customization: grading scheme
\def\grd@title@bas{Grading Scheme}
\define@key{grd@bas}{title}{\def\grd@title@bas{#1}}
\define@key{grd@bas}{color}{\colorlet{TA}{#1}}
\def\gradingsetup#1{\setkeys{grd@bas}{#1}}
% Processing of options at the beginning of the document for multi-pass typesetting
\def\init@ptexport@bas{%
	\export@pt@bastrue%
	\newwrite\tf@pt%
	\immediate\openout\tf@pt\jobname@bas.pt\relax%
}
\def\init@draft@bas{%
	\showpts@bastrue%
	\solution@bastrue\assign@bastrue\ta@bastrue%
}
\def\init@solution@bas{%
	\export@pt@bastrue%
	\newwrite\tf@pt%
	\immediate\openout\tf@pt\jobname@bas.pt\relax%
	\solution@bastrue\ta@basfalse%
	\ifsln@showquestion@bas\assign@bastrue\else\assign@basfalse\fi%
	\ifsln@points@bas\showpts@bastrue\else\showpts@basfalse\fi%
}
\def\init@grading@bas{%
	\showpts@bastrue%
	\solution@bastrue\ta@bastrue%
	\ifsln@showquestion@bas\assign@bastrue\else\assign@basfalse\fi%
}
\def\init@assign@bas{%
	\solution@basfalse\assign@bastrue\ta@basfalse%
}
\AtBeginDocument{%
	\ifstreq@bas{\basmode}{draft}{
		\init@ptexport@bas%
		\init@draft@bas%
	}{}%
	\ifstreq@bas{\basmode}{solution}{%
		\init@ptexport@bas%
		\init@solution@bas%
		\flushbottom%
		\ifstrempty@bas{\sln@title@bas}{}{%
			\edef\@title{\@title, \sln@title@bas}%
		}%
	}{}%
	\ifstreq@bas{\basmode}{grading}{%
		\init@grading@bas%
		\flushbottom%
		\ifstrempty@bas{\grd@title@bas}{}{%
			\edef\@title{\@title, \grd@title@bas}%
		}%
	}{}%
	\ifstreq@bas{\basmode}{assign}{%
		\ifshowpts@bas\init@ptexport@bas\fi%
		\init@assign@bas%
		\flushbottom\pagestyle{empty}%
	}{}%
}
\def\inserttitle{\@title}
%
% Default options that processes all three
\let\document@bas\document
\def\document{%
	\ifx\basmode\undefined%
	  	\immediate\write18{%
	    	pdflatex --enable-write18 --jobname="\jobname@bas_solution"
	    	"\string\makeatletter\string\@input{\jobname@bas_solution.pt}\string\makeatother\gdef\string\basmode{solution}\string\input\space\jobname@bas"
	  	}%
	  	\immediate\write18{%
	    	pdflatex --enable-write18 --jobname="\jobname@bas_grading"
	    	"\string\makeatletter\string\@input{\jobname@bas_solution.pt}\string\makeatother\gdef\string\basmode{grading}\string\input\space\jobname@bas"
	  	}%
	  	\gdef\basmode{assign}%
		\before@document@bas%
		\addtolength{\textheight}{0.1in}%
	  	{\makeatletter\@input{\jobname@bas_solution.pt}\makeatother}%
	\else%
		\ifstreq@bas{\basmode}{draft}{%
			{\makeatletter\@input{\jobname@bas.pt}\makeatother}%
		}{}%
		\ifstreq@bas{\basmode}{grading}{%
			{\makeatletter\@input{\jobname@bas.pt}\makeatother}%
		}{}%
		\ifsln@points@bas%
			\ifstreq@bas{\basmode}{solution}{%
				{\makeatletter\@input{\jobname@bas.pt}\makeatother}%
			}{}%
		\fi%
		\ifstreq@bas{\basmode}{assign}{%
			\ifshowpts@bas%
				{\makeatletter\@input{\jobname@bas.pt}\makeatother}%
			\fi%
			\addtolength{\textheight}{0.1in}%
		}{}%
		\before@document@bas%
	\fi%
\document@bas}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%		Auxiliary macros
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\long\def\comment#1{}
\def\ifempty@bas#1{%
    \ifx\relax#1\relax%
        \expandafter\@firstoftwo%
    \else%
        \expandafter\@secondoftwo%
    \fi%
}
\def\ifstrempty@bas#1{%
    \expandafter\ifx\expandafter\relax#1\relax%
        \expandafter\@firstoftwo%
    \else%
        \expandafter\@secondoftwo%
    \fi%
}
\def\ifstreq@bas#1#2{%
	\xdef\first@bgt{#1}%
	\xdef\second@bgt{#2}%
	\ifx\first@bgt\second@bgt%
		\expandafter\@firstoftwo%
	\else%
		\expandafter\@secondoftwo%
	\fi%
}
\def\expandonce@bas#1{\unexpanded\expandafter{#1}}
\def\before@document@bas{}
\def\BeforeBeginDocument#1{\expandafter\gdef\expandafter\before@document@bas\expandafter{\before@document@bas#1}}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%		Compatibility
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\BeforeBeginDocument{
	\@ifpackageloaded{geometry}{}{\RequirePackage[margin=1in, bottom=1.1in]{geometry}} % used to be 0.92 and 1.02
	\@ifpackageloaded{hyperref}{
		\def\link##1##2{\href{##2}{\begingroup\color{link}\underline{##1}\endgroup}\xspace}
		\def\mailto##1{\href{mailto:##1}{\begingroup\color{link}\underline{##1}\endgroup}\xspace}
	}{}
}
\newif\ifwithindocument@bas
\AtBeginDocument{\withindocument@bastrue}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%
%		Color Scheme
%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\definecolor{points}{rgb}{1,0,0}
\definecolor{bonus}{rgb}{0,0.8,0}
\definecolor{TA}{rgb}{0.4,0.4,0.4}
\colorlet{ptdisplay}{TA}
\definecolor{link}{rgb}{0.12, 0.52, 0.76}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%
%		  Spacing
%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% visible to user
\newlength{\answersep}
\newlength{\beforeheadersep}
\newlength{\afterheadersep}
% invisible to user
\newlength{\parindent@bas}
\newlength{\partopsep@bas}
\newlength{\topsepi@bas}
\newlength{\topsepii@bas}
\newlength{\leftmargini@bas}
\newlength{\leftmarginii@bas}
\newlength{\labelwidthi@bas}
\newlength{\labelwidthii@bas}
\newlength{\labelsepi@bas}
\newlength{\labelsepii@bas}
\newlength{\itemsepi@bas}
\newlength{\itemsepii@bas}
\newlength{\parsepi@bas}
\newlength{\parsepii@bas}
\newlength{\abovecaptionskip@bas}
\newlength{\belowcaptionskip@bas}
\newlength{\displayskip@bas}
%
\newlength{\prev@parskip@bas}
\def\process@parskip@bas{%
	\parsepi@bas\parskip%
	\parsepii@bas\parskip% so that after \process@parskip@bas it has the value \parskip
	\addtolength{\topsepi@bas}{\dimexpr\prev@parskip@bas-\parskip\relax}%
	\addtolength{\topsepii@bas}{\dimexpr\prev@parskip@bas-\parskip\relax}%
	\addtolength{\itemsepi@bas}{\dimexpr\prev@parskip@bas-\parskip\relax}%
	\addtolength{\itemsepii@bas}{\dimexpr\prev@parskip@bas-\parskip\relax}%
	%\addtolength{\parsepi@bas}{\dimexpr\prev@parskip@bas-\parskip\relax}%
	%\addtolength{\parsepii@bas}{\dimexpr\prev@parskip@bas-\parskip\relax}%
	\addtolength{\answersep}{\dimexpr\prev@parskip@bas-\parskip\relax}%
	\addtolength{\afterheadersep}{\dimexpr\prev@parskip@bas-\parskip\relax}%
	%\prev@parskip@bas\parskip%
	\process@spacing@bas%
}
\def\process@spacing@bas{%
	\parindent\parindent@bas%
	\partopsep\partopsep@bas%
	\ifwithindocument@bas%
		\expandafter\abovedisplayskip\the\displayskip@bas%
		\expandafter\belowdisplayskip\the\displayskip@bas%
	\else%
		\AtBeginDocument{\abovedisplayskip\displayskip@bas\belowdisplayskip\displayskip@bas}%
	\fi%
	\linespread{\linespread@bas}%
	\captionsetup{margin={\leftmargini@bas,0cm}, skip=\abovecaptionskip@bas, belowskip=\belowcaptionskip@bas}%
	% 
	\setlist[1]{leftmargin=\leftmargini@bas, labelwidth=\labelwidthi@bas, labelsep=\labelsepi@bas, itemsep=\itemsepi@bas, topsep=\topsepi@bas, parsep=\parsepi@bas}%
	\setlist[2]{leftmargin=\leftmarginii@bas, labelwidth=\labelwidthii@bas, labelsep=\labelsepii@bas, itemsep=\itemsepii@bas, topsep=\topsepii@bas, parsep=\parsepii@bas, listparindent=\parindent@bas}%
}
\define@key{space@bas}{line spread}{\def\linespread@bas{#1}}
\define@key{space@bas}{display skip}{\setlength{\displayskip@bas}{#1}}
\define@key{space@bas}{above caption skip}{\setlength{\abovecaptionskip@bas}{#1}}
\define@key{space@bas}{below caption skip}{\setlength{\belowcaptionskip@bas}{#1}}
\define@key{space@bas}{parindent}{\setlength{\parindent@bas}{#1}}
\define@key{space@bas}{partopsep}{\setlength{\partopsep@bas}{#1}}
\define@key{space@bas}{topsepi}{\setlength{\topsepi@bas}{#1}}
\define@key{space@bas}{topsepii}{\setlength{\topsepii@bas}{#1}}
\define@key{space@bas}{leftmargini}{\setlength{\leftmargini@bas}{#1}}
\define@key{space@bas}{leftmarginii}{\setlength{\leftmarginii@bas}{#1}}
\define@key{space@bas}{labelsepi}{\setlength{\labelsepi@bas}{#1}}
\define@key{space@bas}{labelsepii}{\setlength{\labelsepii@bas}{#1}}
\define@key{space@bas}{labelwidthi}{\setlength{\labelwidthi@bas}{#1}}
\define@key{space@bas}{labelwidthii}{\setlength{\labelwidthii@bas}{#1}}
\define@key{space@bas}{itemsepi}{\setlength{\itemsepi@bas}{#1}}
\define@key{space@bas}{itemsepii}{\setlength{\itemsepii@bas}{#1}}
\define@key{space@bas}{parskip}{\setlength{\parskip}{#1}}
\define@key{space@bas}{parsep}{\setlength{\parskip}{#1}}
%\define@key{space@bas}{parsepi}{\setlength{\parsepi@bas}{#1}}
%\define@key{space@bas}{parsepii}{\setlength{\parsepii@bas}{#1}}
\define@key{space@bas}{afterheadersep}{\setlength{\afterheadersep}{#1}}
\define@key{space@bas}{beforeheadersep}{\setlength{\beforeheadersep}{#1}}
\define@key{space@bas}{answersep}{\setlength{\answersep}{#1}}
\def\setspace#1{\prev@parskip@bas\parskip\setkeys{space@bas}{#1}\process@parskip@bas}
%
% Default spacing
\iffrenchindent@bas
	\parindent@bas1.5em
\else
	\parindent@bas0pt
	\parskip 0.8ex plus 0.1ex
\fi
%\parsepi@bas2\parskip
%\parsepii@bas2\parskip % so that after \process@parskip@bas it has the value \parskip
\partopsep0pt
\displayskip@bas\belowdisplayskip
\setlength{\abovecaptionskip@bas}{1em} % default value
\setlength{\belowcaptionskip@bas}{-0.6em}
\setlength{\topsepi@bas}{1.2ex plus 0.1ex}
\setlength{\topsepii@bas}{1.3ex plus 0.2ex}
\setlength{\leftmargini@bas}{1.76em}
\setlength{\leftmarginii@bas}{2.2em}
\setlength{\labelwidthi@bas}{1.15em}
\setlength{\labelwidthii@bas}{1.7em}
\setlength{\labelsepi@bas}{0.5em}
\setlength{\labelsepii@bas}{0.5em}
\setlength{\itemsepi@bas}{1.1ex plus 0.2ex}
\setlength{\itemsepii@bas}{1.1ex plus 0.2ex}
\setlength{\answersep}{1.2ex plus 0.2ex}
\edef\temp{\the\baselineskip minus \expandafter\the\dimexpr0.5\baselineskip\relax}
\expandafter\beforeheadersep\temp
%
\ifparts@bas
	\afterheadersep1ex
	\setenumerate[1]{label=\textbf{\arabic*.}, align=left}
	\setenumerate[2]{label=\textbf{(\alph*)}, align=left}
\else
	\afterheadersep0.8ex plus 0.2ex
	\setenumerate[1]{label=\textbf{\alph*.}, align=left}
	\setenumerate[2]{label=\textbf{(\roman*)}, align=left}
\fi
\process@parskip@bas
%
%%%%%%%%%%%%%%%%%%%%%
%		Title
%%%%%%%%%%%%%%%%%%%%%
%
% Title
\def\@title{Consider adding a title}
\def\instructions@bas{}
\def\instructions#1{\def\instructions@bas{#1}}
\def\header@bas{\centering%
	\begingroup\bfseries\titlesize@bas\@title\endgroup%
	\ifassign@bas\ifstrempty@bas{\instructions@bas}{}{\par\vskip0.65\baselineskip\begingroup\itshape\instructions@bas\endgroup}\fi\vskip1ex%
}
\def\maketitle{\begingroup\header@bas\endgroup}
%
%%%%%%%%%%%%%%%%%%%%%
%		Points
%%%%%%%%%%%%%%%%%%%%%
%
% Display numbers
\def\displaynum@bas#1.#2\empty@bas{\ifnum#2=0\relax\xdef\disp@bas{#1}\else\def\disp@bas{#1.#2}\fi}
% Make sure that points are added up only once in amsmath's align and similar environments
\newcounter{float@ctr}
\def\addtofloat@bas#1#2{%
	\stepcounter{float@ctr}%
	\ifcsname float@\roman{float@ctr}\endcsname\else%
		\expandafter\gdef\csname float@\roman{float@ctr}\endcsname{}%
		\pgfmathadd{\csname #1\endcsname}{#2}%
		\expandafter\global\expandafter\let\csname #1\endcsname\pgfmathresult%
	\fi%
}%
%
\pgfmathsetmacro{\pointtotal@bas}{0.0}
\pgfmathsetmacro{\pointtotali@bas}{0.0}
\pgfmathsetmacro{\pointtotalii@bas}{0.0}
\newcommand{\pt}[1][1]{%
	\addtofloat@bas{pointtotal@bas}{#1}%
	\addtofloat@bas{pointtotali@bas}{#1}%
	\addtofloat@bas{pointtotalii@bas}{#1}%
	\ifta@bas\text{ \footnotesize\color{points}\smash{[#1pt]}}\xspace\fi%
}
\newcommand{\bonus}[1][1]{\ifta@bas\text{ \footnotesize\color{bonus}\smash{[#1pt]}}\xspace\fi}
\def\pttotal{%
	\ifwithin@list%
		\ifnum\enit@depth>1\relax%
			\pgfmathtruncatemacro{\temp@bas}{\pointtotalii@bas}\temp@bas pt%
		\else%
			\pgfmathtruncatemacro{\temp@bas}{\pointtotali@bas}\temp@bas pt%
		\fi%
	\else%
		\pgfmathtruncatemacro{\temp@bas}{\pointtotal@bas}\temp@bas pt%
	\fi%
}
%
% Store total points
\def\resetctr{\setcounter{problemct@bas}{0}}
\def\storept@bas#1{\expandafter\gdef\expandafter\string\csname point\roman{problemct@bas}@bas\endcsname{#1}}
\def\storepti@bas#1{\expandafter\gdef\expandafter\string\csname point\roman{problemct@bas}@\roman{enumi}@bas\endcsname{#1}}
\def\storeptii@bas#1{\expandafter\gdef\expandafter\string\csname point\roman{problemct@bas}@\roman{enumi}@\roman{enumii}@bas\endcsname{#1}}
%
\def\insertpt@bas{}
\def\insertpt@sep@bas{}
\def\insertpt@list@bas{\ifpt@margin@bas\marginpar{\insertpt@bas}\else\insertpt@bas\insertpt@sep@bas\fi}
\def\ptdisplay#1{\smash{\pt@font@bas\color{ptdisplay}[#1\pt@sep@bas\pt@label@bas\ifstreq@bas{#1}{1}{}{s}]}}
\def\@loadpt@bas{%
	% Check that points are stored
	\@ifundefined{point\roman{problemct@bas}@bas}{}{%
		% Parse the stored points
		\expandafter\expandafter\expandafter\displaynum@bas\csname point\roman{problemct@bas}@bas\endcsname\empty@bas%
		% Set output macro
		\gdef\insertpt@bas{\ptdisplay{\disp@bas}}%
}}
\def\@@loadpt@bas{%
	% Check that points are stored
	\@ifundefined{point\roman{problemct@bas}@\roman{enumi}@bas}{}{%
		% Parse the stored points
		\expandafter\expandafter\expandafter\displaynum@bas\csname point\roman{problemct@bas}@\roman{enumi}@bas\endcsname\empty@bas%
		% Set output macro
		\gdef\insertpt@bas{\ptdisplay{\disp@bas}}%
}}
\def\@@@loadpt@bas{%
	% Check that points are stored
	\@ifundefined{point\roman{problemct@bas}@\roman{enumi}@\roman{enumii}@bas}{}{%
		% Parse the stored points
		\expandafter\expandafter\expandafter\displaynum@bas\csname point\roman{problemct@bas}@\roman{enumi}@\roman{enumii}@bas\endcsname\empty@bas%
		% Set output macro
		\gdef\insertpt@bas{\ptdisplay{\disp@bas}}%
}}
\def\loadpt@bas{%
	% Default
	\gdef\insertpt@bas{}%
	\gdef\insertpt@sep@bas{}%
	\ifshowpts@bas%
		\global\let\insertpt@sep@bas\space%
		\ifwithin@list%
			\ifpt@hierarchy@bas%
				\ifnum\enit@depth=1\relax%
					\@ifundefined{point\roman{problemct@bas}@\roman{enumi}@i@bas}{\@@loadpt@bas}{}%
				\else%
					\@@@loadpt@bas%
				\fi%
			\else%
				\ifnum\enit@depth=1\relax%
					\ifnum\pt@level@bas>1\relax%
						\@@loadpt@bas%
					\fi%
				\else%
					\ifnum\pt@level@bas>2\relax%
						\@@@loadpt@bas%
					\fi%
				\fi%
			\fi%
		\else%
			\ifpt@hierarchy@bas%
				\@ifundefined{point\roman{problemct@bas}@i@bas}{\@loadpt@bas}{}%
			\else%
				\@loadpt@bas%
			\fi%
		\fi%
	\fi\ignorespaces
}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%		Support for xgames
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\def\releasevar{}
\def\resetplayernames{}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%		Copying item
%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Modify the item for spacing issues. Copied essentially from the Latex kernel
\newif\iffirst@subsubanswer
\newif\ifvertical@shift
\newlength\labelwidth@i
\newlength\labelsep@i
\def\item@bas{%
  \@inmatherr\item
  \@ifnextchar [\@@item{\@noitemargtrue \@@item[\@itemlabel]}}
\def\@@item[#1]{%
  \if@noparitem
    \@donoparitem
  \else
    \if@inlabel
      \indent \par
    \fi
    \ifhmode
      \unskip\unskip \par
    \fi
    % keep the vertical box at 0 height if it is not typeset, 
    \vertical@shifttrue
    %\comment{
    \ifendswithdisplay@bas
		\ifanswer@bas
			\ifsolution@bas
    			\vertical@shiftfalse
    			\global\endswithdisplay@basfalse
    		\fi
    	\else
			\ifassign@bas
    			\vertical@shiftfalse
    			\global\endswithdisplay@basfalse
    		\fi
    	\fi
    \fi
    %}
    \ifvertical@shift
      \if@newlist
        \if@nobreak
          \@nbitem
        \else
          \addpenalty\@beginparpenalty
          \addvspace\@topsep
          \addvspace{-\parskip}%
        \fi
      \else
        \addpenalty\@itempenalty
        \addvspace\itemsep
      \fi
    \fi
    \global\@inlabeltrue
  \fi
  \everypar{%
    \@minipagefalse
    \global\@newlistfalse
    \if@inlabel
      %\expandafter\kern\expandafter-\csname leftmargin@\romannumeral\enit@depth\endcsname
      \global\@inlabelfalse
      {\ifassign@bas\else\iffirst@subsubanswer
      	 %\kern\leftmargin@i\kern-\labelsep@i\llap{\theenumi}\kern\labelsep@i\kern-\leftmargin@i
      	 \kern-\leftmargin@ii\kern\leftmargin@i\kern-\labelwidth@i\kern-\labelsep@i\rlap{\theenumi}\kern\labelwidth@i\kern\labelsep@i\kern\leftmargin@ii\kern-\leftmargin@i
       \fi\fi
       %\expandafter\kern\csname leftmargin@\romannumeral\enit@depth\endcsname
       \setbox\z@\lastbox
       \ifvoid\z@
         \kern-\itemindent
       \fi}%
      \box\@labels
      \penalty\z@
    \fi
	\expandafter\global\expandafter\hangindent\csname leftmargin@\romannumeral\enit@depth\endcsname
	\global\hangafter0
	\parindent\parindent@bas
    \if@nobreak
      \@nobreakfalse
      \clubpenalty \@M
    \else
      \clubpenalty \@clubpenalty
      \everypar{}%
    \fi}%
  \if@noitemarg
    \@noitemargfalse
    \if@nmbrlist
      \refstepcounter\@listctr
    \fi
  \fi
  \sbox\@tempboxa{\makelabel{#1}}%
  \global\setbox\@labels\hbox{%
    \unhbox\@labels
    \hskip \itemindent
    \hskip -\labelwidth
    \hskip -\labelsep
    \ifdim \wd\@tempboxa >\labelwidth
      \box\@tempboxa
    \else
      \hbox to\labelwidth {\unhbox\@tempboxa}%
    \fi
    \hskip \labelsep}%
  \ignorespaces}
%
%%%%%%%%%%%%%%%%%%%%%%%%
%		Filtering
%%%%%%%%%%%%%%%%%%%%%%%%
%
\newif\iffilter@bas
\newif\iffilter@and@bas
\newif\ifinclude@bas
%
\def\filter{\@ifnextchar[{\@filter@bas}{\@filter@bas[]}}
\def\@filter@bas[#1]#2{%
	\filter@bastrue%
	\ifstreq@bas{#1}{and}{\filter@and@bastrue}{\filter@and@basfalse}%
	\def\filter@bas{#2}%
}
%
\newif\ifmath@below@bas
\newif\ifmath@above@bas
\newif\ifconcept@below@bas
\newif\ifconcept@above@bas
\define@key{diff@bas}{math}{\def\math@bas{#1}}
\define@key{diff@bas}{math<}{\def\math@bas{#1}\math@below@bastrue}
\define@key{diff@bas}{math <}{\def\math@bas{#1}\math@below@bastrue}
\define@key{diff@bas}{math>}{\def\math@bas{#1}\math@above@bastrue}
\define@key{diff@bas}{math >}{\def\math@bas{#1}\math@above@bastrue}
\define@key{diff@bas}{concept}{\def\concept@bas{#1}}
\define@key{diff@bas}{concept<}{\def\concept@bas{#1}\concept@below@bastrue}
\define@key{diff@bas}{concept <}{\def\concept@bas{#1}\concept@below@bastrue}
\define@key{diff@bas}{concept>}{\def\concept@bas{#1}\concept@above@bastrue}
\define@key{diff@bas}{concept >}{\def\concept@bas{#1}\concept@above@bastrue}
\def\difficulty#1{\filter@bastrue\setkeys{diff@bas}{#1}}
%
\newif\iffun@below@bas
\newif\iffun@above@bas
\newif\ifinstructive@below@bas
\newif\ifinstructive@above@bas
\define@key{quality@bas}{fun}{\def\fun@bas{#1}}
\define@key{quality@bas}{fun<}{\def\fun@bas{#1}\fun@below@bastrue}
\define@key{quality@bas}{fun <}{\def\fun@bas{#1}\fun@below@bastrue}
\define@key{quality@bas}{fun>}{\def\fun@bas{#1}\fun@above@bastrue}
\define@key{quality@bas}{fun >}{\def\fun@bas{#1}\fun@above@bastrue}
\define@key{quality@bas}{instructive}{\def\instructive@bas{#1}}
\define@key{quality@bas}{instructive<}{\def\instructive@bas{#1}\instructive@below@bastrue}
\define@key{quality@bas}{instructive <}{\def\instructive@bas{#1}\instructive@below@bastrue}
\define@key{quality@bas}{instructive>}{\def\instructive@bas{#1}\instructive@above@bastrue}
\define@key{quality@bas}{instructive >}{\def\instructive@bas{#1}\instructive@above@bastrue}
\def\quality#1{\filter@bastrue\setkeys{quality@bas}{#1}}
%
\def\resetfilter@bas{%
	\iffilter@bas%
		\first@filter@bastrue%
		\include@basfalse%
	\else%
		\include@bastrue%
	\fi%
}
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%		Main commands
%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
\newbox\assign@box
\newif\ifwithin@problem
\newif\ifwithin@assignbox
\newif\ifwithin@list
\newif\ifafter@list
\newif\ifafter@sublist
\newif\ifanswer@bas
%
\def\assign#1{\ifassign@bas#1\fi}
\def\solution#1{\ifsolution@bas#1\fi}
\def\draft#1{\ifassign@bas\ifsolution@bas#1\fi\fi}
\def\warning#1{
	\ifassign@bas\ifsolution@bas
		\vskip\answersep%
		\par\begingroup\color{red}#1\endgroup
\fi\fi}
%
\newlength\@Aheight
\settoheight{\@Aheight}{A}
%
\newcounter{stored@enumi@bas}
\setcounter{stored@enumi@bas}{0}
\newcounter{stored@enumii@bas}
\setcounter{stored@enumii@bas}{0}
%
\def\store@enum@bas{\setcounter{stored@enum\romannumeral\the\enit@depth @bas}{\value{enum\romannumeral\the\enit@depth}}}
\def\restore@enum@bas{\setcounter{enum\romannumeral\the\enit@depth}{\value{stored@enum\romannumeral\the\enit@depth @bas}}}
\def\set@enum@bas#1{\setcounter{enum\romannumeral\the\enit@depth}{\numexpr#1-1\relax}}
\def\reduce@enum@bas{\addtocounter{enum\romannumeral\the\enit@depth}{-1}}
%
% The idea to store code in a vbox and \unvbox is taken from Paul Pichaureau's exercise.sty. 
%
\def\store@counters@bas{%
	\xdef\store@equation@bas{\theequation}%
	\xdef\store@figure@bas{\thefigure}%
	\xdef\store@table@bas{\thetable}%
}
\def\restore@counters@bas{%
	\global\setcounter{equation}{\store@equation@bas}%
	\global\setcounter{figure}{\store@figure@bas}%
	\global\setcounter{table}{\store@table@bas}%
}
\def\open@assignbox{%
	\within@assignboxtrue%
	\store@counters@bas%
	\setbox\assign@box\vbox\bgroup%
}
\newlength{\lastbox@skip}
\newif\iftypesetbox@bas
\newif\ifendswithdisplay@bas
%\def\interlineskip@bas{\expandafter\vskip\dimexpr\baselineskip-\@Aheight-\lastbox@depth\relax}
\def\close@assignbox{%
	\ifwithin@assignbox%
		% store last skip to decide whether it ended in an equation
		\par\global\lastbox@skip\lastskip%
		\ifexport@pt@bas%
			\immediate\write\@auxout{\string\@writefile{pt}{\storept@bas{\pointtotal@bas}}}%
			\ifwithin@list%
				\immediate\write\@auxout{\string\@writefile{pt}{\storepti@bas{\pointtotali@bas}}}%
				\ifnum\enit@depth>1\relax%
					\immediate\write\@auxout{\string\@writefile{pt}{\storeptii@bas{\pointtotalii@bas}}}%
				\fi%
			\fi%
		\fi%
		% measure depth of last pargraph in box
		\par\ifdim\prevdepth=-1000pt\gdef\lastbox@depth{0pt}\else\xdef\lastbox@depth{\the\prevdepth}\fi%
		% if an equation is very deep, we don't want to remove more than \belowdisplayskip
		\expandafter\ifdim\lastbox@depth>\belowdisplayskip\xdef\lastbox@depth{\the\belowdisplayskip}\fi%
		% Move last skip outside of box for page breaks
		\vskip-\lastbox@skip%
		\egroup%
		\typesetbox@basfalse%
		\ifdim\wd\assign@box>0pt%
%			non-empty
			% typeset anything at all only if the box isn't empty.
			\ifanswer@bas%
				\ifsolution@bas%
					\unvbox\assign@box%\the\lastbox@skip,\lastbox@depth%
					\vskip\lastbox@skip%
					% if anything has been typeset, we are no longer after a sublist
					\global\after@sublistfalse%
					\global\after@listfalse%
					\global\typesetbox@bastrue%
					% fake an \interlineskip
					\vskip\dimexpr\baselineskip-\@Aheight-\lastbox@depth\relax%
					% remember that last box ended in an equation
					\ifdim\lastbox@skip>0.5\belowdisplayskip%
						\global\endswithdisplay@bastrue%
					\fi%
				\fi%
			\else%
				\ifassign@bas%
					\unvbox\assign@box%
					\vskip\lastbox@skip%
					% if anything has been typeset, we are no longer after a sublist
					\global\after@sublistfalse%
					\global\after@listfalse%
					\global\typesetbox@bastrue%
					% fake an \interlineskip
					\vskip\dimexpr\baselineskip-\@Aheight-\lastbox@depth\relax%
					% remember that last box ended in an equation
					\ifdim\lastbox@skip>0.5\belowdisplayskip%
						\global\endswithdisplay@bastrue%
					\fi%
				\fi%
			\fi%
		\fi%
		\iftypesetbox@bas\else%
			\restore@counters@bas%
		\fi%
		\within@assignboxfalse%
	\fi%
}
\let\slnqfont\itshape
\let\qfont\normalshape
\colorlet{slnquestion}{black}
\colorlet{question}{black}
\def\open@qbox{%
	% open box
	\answer@basfalse%
	\open@assignbox%
	% issue item if needed
	\ifwithin@list%
		\ifafter@sublist%
			\item@bas[]%
		\else%
			\item@bas\noindent\loadpt@bas\insertpt@list@bas%
	\fi\fi%
	% in italics if both question and answer are displayed
	\ifsolution@bas\color{slnquestion}\slnqfont\else\color{question}\qfont\fi%
	\ignorespaces%
}
\def\afont{}
\colorlet{answer}{black}
\newif\ifanswer@indent@bas
\def\answerindent@bas{\noindent\ifanswer@indent@bas\hskip\parindent\fi}
%\def\answerindent@bas{\ifanswer@indent@bas\else\noindent\fi}
\def\open@abox{%
	% open box
	\answer@bastrue%
	\open@assignbox%
	% issue item if needed
	\ifwithin@list%
		\ifassign@bas%
			\item@bas[]
		\else%
			\ifafter@sublist%
				\global\@newlistfalse%
			\else%
				\reduce@enum@bas%
				\ifnum\value{enum\romannumeral\enit@depth}=0%
					\global\@newlisttrue%
				\fi%
			\fi%
			% so points are displayed for grading scheme
			\item@bas\ifta@bas\ifsln@showquestion@bas\else\noindent\loadpt@bas\insertpt@list@bas\fi\fi
		\fi%
	\else%
		\vskip\answersep%
	\fi%
	% for some reason I need to isse a text here for the item to be generated. 
	\iffirst@subsubanswer\vphantom{t}\fi% probably \null would be appropriate?
	\global\first@subsubanswerfalse%
	\color{answer}\afont%
	\ignorespaces%
}
\newcommand{\question}[1][]{%
	\close@assignbox%
	\ifafter@sublist%
		\pgfmathsetmacro{\pointtotali@bas}{0.0}%
		\ifassign@bas\vskip-\itemsep\fi% prevent double spacing
		\after@sublistfalse%
	\else%
		\ifnum\enit@depth=1\relax%
			\pgfmathsetmacro{\pointtotali@bas}{0.0}%
		\else%
			\ifnum\enit@depth=2\relax%
				\pgfmathsetmacro{\pointtotalii@bas}{0.0}%
			\fi%
		\fi%
	\fi%
	\open@qbox%
}
\long\def\answer{%
	\close@assignbox%
	\open@abox\expandafter\answerindent@bas\sln@header@bas%
}
%
\let\enum@bas\enumerate
\let\endenum@bas\endenumerate
\newlength{\tempdimen}
%
\newenvironment{subproblems}[1][]{%
	% \ifassign@bas\vskip\parskip\else\ifafter@list\else\vskip\parskip\fi\fi% 0302
	% \ifassign@bas\else\ifafter@list\vskip-\parskip\fi\fi%
	% \iffrenchindent@bas\ifnum\value{stored@enumi@bas}>0\relax\vskip\topsepi@bas\fi\fi%
	\begin{enum@bas}%
	\ifassign@bas\else\ifafter@list\vskip-\topsep\vskip-\parskip\fi\fi%
	\setcounter{stored@enumii@bas}{0}%
	\ifstreq@bas{#1}{}{\restore@enum@bas}{\set@enum@bas{#1}}%
	\xdef\leftmargin@i{\the\leftmargin}%
	\within@listtrue%
}{
	\close@assignbox%
	\store@enum@bas%
	\vskip-\parsep%
	\ifassign@bas\ifafter@sublist\vskip-\topsep\fi\fi% prevent double spacing
	\tempdimen\dimexpr\topsep+\parsep\relax%
	\ifendswithdisplay@bas\expandafter\ifdim\tempdimen<\lastbox@depth\relax\vskip-\tempdimen\else\vskip-\lastbox@depth\fi\global\endswithdisplay@basfalse\fi% only add larger space
	\end{enum@bas}%
}
%
\BeforeBeginEnvironment{subproblems}{\close@assignbox}
\AfterEndEnvironment{subproblems}{\within@listfalse\after@listtrue\open@qbox}
%
\newenvironment{subsubproblems}[1][]{%
	% store label sep of first enumerate
	\setlength{\labelsep@i}{\the\labelsep}%
	\setlength{\labelwidth@i}{\the\labelwidth}%
	% spacing correction needed when assignment text isn't shown
	\ifassign@bas\else%
		\ifafter@sublist\else%
			\ifnum\value{enumi}=1%
				\vskip\dimexpr\topsep+\parskip-\parsep\relax%
			\else%
				\vskip\dimexpr\itemsep+\parsep\relax% 
			\fi%
		\fi%
	\fi%
	\begin{enum@bas}%
	% store total indent for \everypar in \@@item
	%\xdef\leftmargin@ii{\expandafter\expandafter\expandafter\the\expandafter\dimexpr\the\leftmargin+\leftmargin\relax}%
	\xdef\leftmargin@ii{\expandafter\the\dimexpr\leftmargin+\labelsep@i+\labelwidth@i\relax}%
	% process optional argument
	\ifstreq@bas{#1}{}{\restore@enum@bas}{\set@enum@bas{#1}}%
	\ifafter@sublist\vskip-\parsep\else\ifnum\value{enumii}=0\global\first@subsubanswertrue\fi\fi%
	% in the solution, subsubproblems don't start their own paragraph
	\ifassign@bas\else\vskip-\topsep\fi% 
}{%
	\close@assignbox%
	\store@enum@bas%
	\vskip-\parsep%
	\tempdimen\dimexpr\topsep+\parsep\relax%
	\ifendswithdisplay@bas\expandafter\ifdim\tempdimen<\lastbox@depth\relax\vskip-\tempdimen\else\vskip-\lastbox@depth\fi\global\endswithdisplay@basfalse\fi% only add larger space
	\end{enum@bas}%
}
\BeforeBeginEnvironment{subsubproblems}{\close@assignbox}
\AfterEndEnvironment{subsubproblems}{\global\after@sublisttrue\open@qbox}
%
\newlength{\spw@bas}
\settowidth{\spw@bas}{\space}
\newcounter{problemct@bas} % internal for storing points
\newcounter{problem} % external for display
\def\problem@source@bas{}
\def\problem@title@bas{}
% Make header more easily customizable
\def\insertproblemnumber{\theproblem}
\def\insertproblemtitle{\problem@title@bas}
\def\insertproblemsource{\problem@source@bas}
\def\insertproblempoints{\loadpt@bas\insertpt@bas}
% Test for end punctuation in problem title
\newif\ifpunct@bas
\def\testpunct@bas#1{%
	\punct@basfalse%
	\expandafter\question@bas\expandafter{\expandafter#1\expandafter}#1\end ?\end\eend%
	\expandafter\exclamation@bas\expandafter{\expandafter#1\expandafter}#1\end !\end\eend%
	\expandafter\period@bas\expandafter{\expandafter#1\expandafter}#1\end .\end\eend%
	\expandafter\ldots@bas\expandafter{\expandafter#1\expandafter}#1\end\ldots\end\eend%
	#1%
}
\def\xdot@bas{\ifpunct@bas\else.\fi}
\def\question@bas#1#2?\end#3\eend{\ifx\end#3\end\relax\else\punct@bastrue\fi}
\def\exclamation@bas#1#2!\end#3\eend{\ifx\end#3\end\relax\else\punct@bastrue\fi}
\def\period@bas#1#2.\end#3\eend{\ifx\end#3\end\relax\else\punct@bastrue\fi}
\def\ldots@bas#1#2\ldots\end#3\eend{\ifx\end#3\end\relax\else\punct@bastrue\fi}
%
\ifparts@bas
	\def\problemheader{%
		\large\bfseries Part \Roman{problem}\ifstrempty@bas{\problem@title@bas}{}{: \problem@title@bas\ifqbank@bas\ifstrempty@bas{\problem@level@bas}{}{, \problem@level@bas}\fi}\ifstrempty@bas{\problem@source@bas}{}{ (\problem@source@bas)}%
	}
	\def\insert@problemheader@bas{%
		\clearpage%
		\begin{center}%
			\noindent\problemheader%
		\end{center}%
		\vskip\afterheadersep\ignorespaces%
	}
	\def\starredproblemheader{%
		\large\bfseries \problem@title@bas\ifqbank@bas\ifstrempty@bas{\problem@level@bas}{}{, \problem@level@bas}\fi\ifstrempty@bas{\problem@source@bas}{}{ (\problem@source@bas)}%
	}
	\def\insert@starredproblemheader@bas{%
		\clearpage%
		\begin{center}%
			\noindent\starredproblemheader%
		\end{center}%
		\vskip\afterheadersep\ignorespaces%
	}
\else
	\def\problemheader{%
		\begingroup%
			\bfseries Problem \theproblem\ifstrempty@bas{\problem@title@bas}{}{. \testpunct@bas{\problem@title@bas}\ifqbank@bas\ifstrempty@bas{\problem@level@bas}{}{, \problem@level@bas\punct@basfalse}\fi}\ifstrempty@bas{\problem@source@bas}{}{ (\problem@source@bas)\punct@basfalse}\xdot@bas%
		\endgroup%
		\hfill\loadpt@bas\ifpt@margin@bas\gdef\add@pt@margin@bas{\marginpar{\insertpt@bas}}\else\insertpt@bas\fi%
	}
	\def\insert@problemheader@bas{%
		\par\vskip\beforeheadersep%
		\setbox0=\hbox{\problemheader}%
		\gdef\lastbox@depth{\the\dp0}%
		\noindent\unhbox0\add@pt@margin@bas%
		\par\vskip\dimexpr\baselineskip-\@Aheight-\lastbox@depth-2pt\relax%
		\vskip\afterheadersep%
		% because there is no text before the first item in the solution, an itemsep will look more homogenous than a topsep
		\ifassign@bas\else\vskip\dimexpr\itemsep-\topsep\fi\ignorespaces%
	}
	\def\starredproblemheader{%
		\begingroup%
			\bfseries \testpunct@bas{\problem@title@bas}\ifqbank@bas\ifstrempty@bas{\problem@level@bas}{}{, \problem@level@bas\punct@basfalse}\fi\ifstrempty@bas{\problem@source@bas}{}{ (\problem@source@bas)\punct@basfalse}\xdot@bas%
		\endgroup%
		\hfill\loadpt@bas\ifpt@margin@bas\gdef\add@pt@margin@bas{\marginpar{\insertpt@bas}}\else\insertpt@bas\fi%
	}
	\def\insert@starredproblemheader@bas{%
		\par\vskip\beforeheadersep%
		\setbox0=\hbox{\starredproblemheader}%
		\gdef\lastbox@depth{\the\dp0}%
		\noindent\unhbox0\add@pt@margin@bas%
		\par\vskip\dimexpr\baselineskip-\@Aheight-\lastbox@depth\relax%
		\vskip\afterheadersep%
		% because there is no text before the first item in the solution, an itemsep will look more homogenous than a topsep
		\ifassign@bas\else\vskip\dimexpr\itemsep-\topsep\fi\ignorespaces%
	}
\fi
\def\problem@level@bas{}
\define@key{problem@bas}{source}{\def\problem@source@bas{#1}}
\define@key{problem@bas}{inspiration}{\def\problem@source@bas{Inspired by #1}}
\define@key{problem@bas}{title}{\def\problem@title@bas{#1}}
\define@key{problem@bas}{level}{\def\problem@level@bas{#1}}
\define@key{problem@bas}{version}{\def\problem@level@bas{#1}}
% simulating document modes
\define@key{problem@bas}{draft}[true]{\init@draft@bas}
\define@key{problem@bas}{solution}[true]{\init@solution@bas}
\define@key{problem@bas}{assign}[true]{\init@assign@bas}
\define@key{problem@bas}{points}[true]{\init@assign@bas\showpts@bastrue}
\define@key{problem@bas}{ta}[true]{\init@grading@bas}
\define@key{problem@bas}{grading}[true]{\init@grading@bas}
%
\newif\if@include@bas
\newif\iftemp@include@bas
\newif\iffirst@filter@bas
\define@key{problem@bas}{labels}{%
	\@ifundefined{filter@bas}{}{%
		\iffilter@and@bas%
			\@include@bastrue%
		\else%
			\@include@basfalse%
		\fi%
		\def\temp@a{\foreach \item@bas in}%
		\expandafter\temp@a\expandafter{\filter@bas} {%
			\temp@include@basfalse%
			\foreach \i@bas in {#1} {\ifstreq@bas{\i@bas}{\item@bas}{\global\temp@include@bastrue}{}}%
			\iffilter@and@bas%
				\iftemp@include@bas\else\global\@include@basfalse\fi%
			\else%
				\iftemp@include@bas\global\@include@bastrue\fi%
			\fi%
		}%
		\iffirst@filter@bas%
			\global\first@filter@basfalse%
			\if@include@bas\global\include@bastrue\fi%
		\else%
			\if@include@bas\else\global\include@basfalse\fi%
		\fi%
	}%
}
\define@key{problem@bas}{difficulty}{%
	\iffilter@bas%
		\@include@bastrue%
		\foreach[count=\j@bgt] \item@bgt in {#1} {%
			\ifnum\j@bgt=1\relax%
				\@ifundefined{concept@bas}{}{%
					\temp@include@basfalse%
					\ifnum\item@bgt=\concept@bas\relax%
						\temp@include@bastrue%
					\else%
						\ifnum\item@bgt<\concept@bas\relax%
							\ifconcept@below@bas\temp@include@bastrue\fi%
						\else%
							\ifconcept@above@bas\temp@include@bastrue\fi%
						\fi%
					\fi%
					\iftemp@include@bas\else\global\@include@basfalse\fi%
				}%
			\else%
				\@ifundefined{math@bas}{}{%
					\temp@include@basfalse%
					\ifnum\item@bgt=\math@bas\relax%
						\temp@include@bastrue%
					\else%
						\ifnum\item@bgt<\math@bas\relax%
							\ifmath@below@bas\temp@include@bastrue\fi%
						\else%
							\ifmath@above@bas\temp@include@bastrue\fi%
						\fi%
					\fi%
					\iftemp@include@bas\else\global\@include@basfalse\fi%
				}%
			\fi%
		}%
		\iffirst@filter@bas%
			\global\first@filter@basfalse%
			\if@include@bas\global\include@bastrue\fi%
		\else%
			\if@include@bas\else\global\include@basfalse\fi%
		\fi%
	\fi%
}
\define@key{problem@bas}{quality}{%
	\iffilter@bas%
		\@include@bastrue%
		\foreach[count=\j@bgt] \item@bgt in {#1} {%
			\ifnum\j@bgt=1\relax%
				\@ifundefined{instructive@bas}{}{%
					\temp@include@basfalse%
					\ifnum\item@bgt=\instructive@bas\relax%
						\temp@include@bastrue%
					\else%
						\ifnum\item@bgt<\instructive@bas\relax%
							\ifinstructive@below@bas\temp@include@bastrue\fi%
						\else%
							\ifinstructive@above@bas\temp@include@bastrue\fi%
						\fi%
					\fi%
					\iftemp@include@bas\else\global\@include@basfalse\fi%
				}%
			\else%
				\@ifundefined{fun@bas}{}{%
					\temp@include@basfalse%
					\ifnum\item@bgt=\fun@bas\relax%
						\temp@include@bastrue%
					\else%
						\ifnum\item@bgt<\fun@bas\relax%
							\iffun@below@bas\temp@include@bastrue\fi%
						\else%
							\iffun@above@bas\temp@include@bastrue\fi%
						\fi%
					\fi%
					\iftemp@include@bas\else\global\@include@basfalse\fi%
				}%
			\fi%
		}%
		\iffirst@filter@bas%
			\global\first@filter@basfalse%
			\if@include@bas\global\include@bastrue\fi%
		\else%
			\if@include@bas\else\global\include@basfalse\fi%
		\fi%
	\fi%
}
%
\def\float@within@bas{%
	\let\figure\figure@within@bas%
	\let\endfigure\endfigure@within@bas%
	\let\table\table@within@bas%
	\let\endtable\endtable@within@bas%
}
\def\float@outside@bas{%
	\let\figure\figure@outside@bas%
	\let\endfigure\endfigure@outside@bas%
	\let\table\table@outside@bas%
	\let\endtable\endtable@outside@bas%
}
\def\problem@endspace@bas{%
	\par\ifafter@list\vskip\dimexpr\baselineskip-\prevdepth-\@Aheight-\topsep-0.5pt\relax\fi% 0.5pt ad-hoc
}
\def\savecolor@bas{\xglobal\colorlet{currcol@bas}{.}}
\def\resetcolor@bas{\color{currcol@bas}}
\colorlet{currcol@bas}{.}
\ifqbank@bas
	\NewEnviron{problem}[1][]{%
		\def\add@pt@margin@bas{}%
		\savecolor@bas%
		\let\problem@body@bas\BODY%
		\iffilter@bas\include@basfalse\first@filter@bastrue\else\include@bastrue\fi%
		\setkeys{problem@bas}{#1}%
		\ifinclude@bas%
			\stepcounter{problemct@bas}%
			\refstepcounter{problem}%
			\setcounter{stored@enumi@bas}{0}%
			\pgfmathsetmacro{\pointtotal@bas}{0.0}%
			\float@within@bas%
			\within@problemtrue%
			\after@listfalse%
			\after@sublistfalse%
			\insert@problemheader@bas%
			\open@qbox\noindent\ignorespaces%
			\problem@body@bas%
			\close@assignbox%
			\within@problemfalse%
		\fi%
	}{\float@outside@bas\problem@endspace@bas\resetcolor@bas}
\else
	\newenvironment{problem}[1][]{%
		\def\add@pt@margin@bas{}%
		\savecolor@bas%
		\setkeys{problem@bas}{#1}%
		\stepcounter{problemct@bas}%
		\refstepcounter{problem}%
		\setcounter{stored@enumi@bas}{0}%
		\pgfmathsetmacro{\pointtotal@bas}{0.0}%
		\float@within@bas%
		\within@problemtrue%
		\after@listfalse%
		\after@sublistfalse%
		\insert@problemheader@bas%
		\open@qbox\noindent\ignorespaces%
	}{
		\close@assignbox%
		\float@outside@bas%
		\within@problemfalse%
		\problem@endspace@bas%
		\aftergroup\resetcolor@bas%
	}
	\newenvironment{problem*}[1][]{%
		\def\add@pt@margin@bas{}%
		\savecolor@bas%
		\setkeys{problem@bas}{#1}%
		\stepcounter{problemct@bas}%
		\refstepcounter{problem}%
		\setcounter{stored@enumi@bas}{0}%
		\pgfmathsetmacro{\pointtotal@bas}{0.0}%
		\float@within@bas%
		\within@problemtrue%
		\after@listfalse%
		\after@sublistfalse%
		\insert@starredproblemheader@bas%
		\open@qbox\noindent\ignorespaces%
	}{
		\close@assignbox%
		\float@outside@bas%
		\within@problemfalse%
		\problem@endspace@bas%
		\aftergroup\resetcolor@bas%
	}
\fi
\AfterEndEnvironment{problem}{\nointerlineskip\ifsolution@bas\vspace*{0.5ex}\fi\releasevar\resetplayernames}
%
% Support for floats
\newif\if@floatdisplay
\def\reset@everypar{%
	\everypar{%
		\expandafter\global\expandafter\hangindent\csname leftmargin@\romannumeral\enit@depth\endcsname
		\global\hangafter0
}}
% Floats
\globaldefs=1
\foreach \float@bas in {table, figure} {
	\expandafter\let\csname\float@bas @bas\expandafter\endcsname\csname\float@bas\endcsname
	\expandafter\let\csname end\float@bas @bas\expandafter\endcsname\csname end\float@bas\endcsname
	\edef\tempname@bas{\float@bas @within@bas}
		\expandafter\expandafter\expandafter\NewEnviron\expandafter\expandafter\expandafter{\expandafter\tempname@bas\expandafter}\expandafter[\expandafter1\expandafter]\expandafter[\expandafter t\expandafter]\expandafter{\expandafter\def\expandafter\float@bas\expandafter{\float@bas}% Expand \float@bas at time of definition
		\@floatdisplayfalse%
		\ifanswer@bas%
			\ifsolution@bas%
				\global\@floatdisplaytrue%
			\fi%
		\else%
			\ifassign@bas%
				\global\@floatdisplaytrue%
		\fi\fi%
		\if@floatdisplay%
			\expandafter\begin\expandafter{\float@bas @bas}[##1]\centering%
			\BODY%
			\expandafter\end\expandafter{\float@bas @bas}%
		\fi%
	}{}
	\edef\tempname@bas{\float@bas @outside@bas}
		\expandafter\expandafter\expandafter\NewEnviron\expandafter\expandafter\expandafter{\expandafter\tempname@bas\expandafter}\expandafter[\expandafter2\expandafter]\expandafter[\expandafter t\expandafter]\expandafter{\expandafter\def\expandafter\float@bas\expandafter{\float@bas}%
		\@floatdisplayfalse%
		\ifsolution@bas%
			\ifstreq@bas{##2}{solution}{\global\@floatdisplaytrue}{\ifstreq@bas{##2}{both}{\global\@floatdisplaytrue}{}}%
			\ifassign@bas\ifstreq@bas{##2}{assign}{\global\@floatdisplaytrue}{}\fi%
		\else%
			\ifstreq@bas{##2}{assign}{\global\@floatdisplaytrue}{\ifstreq@bas{##2}{both}{\global\@floatdisplaytrue}{}}%
		\fi%
		\if@floatdisplay%
			\expandafter\begin\expandafter{\float@bas @bas}[##1]\centering%
			\BODY%
			\expandafter\end\expandafter{\float@bas @bas}%
		\fi%
	}{}
	\expandafter\let\csname\float@bas\expandafter\endcsname\csname\float@bas @outside@bas\endcsname
	\expandafter\let\csname end\float@bas\expandafter\endcsname\csname end\float@bas @outside@bas\endcsname
	\expandafter\BeforeBeginEnvironment\expandafter{\float@bas}{\close@assignbox}
	\expandafter\AfterEndEnvironment\expandafter{\float@bas}{\ifwithin@list\reset@everypar\fi\ifwithin@problem\open@assignbox\fi}
}
\globaldefs=0
%
% Enumerate / itemize
\AfterEndEnvironment{enumerate}{\ifwithin@list\reset@everypar\fi}
\AfterEndEnvironment{itemize}{\ifwithin@list\reset@everypar\fi}
%
\let\hfont\itshape%
\colorlet{hint}{black}
\long\def\hint#1{%
	\ifassign@bas%
		\vskip\answersep%
		\par\begingroup\color{hint}\hfont Hint: #1\endgroup%
	\fi%
}
%
% Instructions for TA % \setbox0 ensures that \pt issued in \ta are counted
\long\def\ta#1{\ifvmode\leavevmode\fi\ifta@bas\begingroup\color{TA}[#1]\endgroup\else\setbox0=\hbox{#1}\ignorespaces\fi}
% Some layout adjustments
\linepenalty=5000
\setlength{\jot}{3mm}%
% Random
\def\largeskip{\vskip9pt plus 3pt minus 3pt}
\makeatother